/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 mouse;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution; // Replaced for VGHD by defines above. TheEmu.

#define WAVE_SPEED 5.
#define ROTA_SPEED 0.*10.*cos(time)
#define N_BRANCHES 10.
#define K_DIST time

void main( void ) {

	vec2 uv = 2.*vec2(gl_FragCoord.x / resolution.x-.5, gl_FragCoord.y / resolution.y -.5);
	float dist = length(uv) + 1.;
	uv.y*=resolution.y/resolution.x;
	vec2 altuv = uv;
	//altuv.y*=-cos(dist*time);
	altuv.x*=-sin(dist*time);
	
	float r = cos(atan(altuv.y, altuv.x)*N_BRANCHES+ROTA_SPEED + dist*K_DIST + 1.);
	float g = cos(atan(altuv.y, altuv.x)*N_BRANCHES+ROTA_SPEED + dist*K_DIST + 0.);
	float b = cos(atan(altuv.y, altuv.x)*N_BRANCHES+ROTA_SPEED + dist*K_DIST - 1.);
	
	//g = mix(g, .5, .75+.25*cos(uv.y*200.));
	
	vec3 color = vec3(r, g, b);
	
	
	gl_FragColor = vec4( color, 1.0 );

}